package main

import (
	"fmt"
	"fss_demo/auth"
	"io"
	"io/ioutil"
	"log"
	"net"
	"net/http"
	"time"
)

type utils struct {
	basrUrl string
	auth *auth.Authorize
	request *http.Request
}

func newUtils(basrUrl string, auth *auth.Authorize) *utils {
	return &utils{basrUrl: basrUrl, auth: auth}
}

func (u *utils)createRequest(body io.Reader) *utils {
	url := u.basrUrl+ u.auth.Uri()
	request, err := http.NewRequest(string(u.auth.Method()), url, body)
	if err != nil{
		log.Fatalln(err)
	}
	request.Header.Set("Authorization", u.auth.BuildAuthorize())
	request.Header.Set("Date", u.auth.DateStr())
	u.request = request;
	return u
}

// 执行请求
func (u *utils)doRequest() *http.Response {
	tr := &http.Transport{
		//DisableCompression: true,
		DisableKeepAlives: true,
		//IdleConnTimeout: time.Millisecond*3,
		DialContext: (&net.Dialer{
			Timeout:   30 * time.Second,
			KeepAlive: -1,
		}).DialContext,
	}
	client := &http.Client{
		Transport: tr,
		//Timeout: time.Second*5,
	}
	response, err := client.Do(u.request)
	if err != nil{
		log.Fatalln(err)
	}
	return response
}

// 设置请求参数
func (u *utils)setParam(param map[string]string)*utils  {
	for k,v := range param {
		u.request.Header.Set(k, v)
	}
	return u
}

func (u *utils)printResult()  {
	response := u.doRequest()
	all, err:= ioutil.ReadAll(response.Body)
	if err != nil{
		log.Fatalln(err)
	}

	response.Body.Close()
	fmt.Printf("响应体: %+v \n", string(all))
	fmt.Printf("响应头: %+v \n", response.Header)
	fmt.Printf("状态码: %+v \n", response.Status)
}
