import base64, hmac, hashlib, datetime, os, re, math
from urllib.parse import urlparse
from urllib.parse import urlencode
from urllib import request
from urllib import error
from urllib.parse import quote
import string, pytz


class restapi:
    _username = ''
    _password = ''
    _checkAction = 0
    _url = ''
    _method = ''
    _contentMd5 = ''
    _date = ''
    _async = ''

    def __init__(self, username, password, checkAction):
        self._username = username
        self._password = password
        self._checkAction = checkAction

    def setUrl(self, url):
        parse = urlparse(url)
        self._url = parse.scheme+'://'+parse.netloc+'/'+quote(parse.path[1:], safe=string.printable)
        if parse.query:
            self._url += '?'+parse.query

    def setMethod(self, method):
        self._method = method

    def setContentMd5(self, md5):
        self._contentMd5 = md5

    def setDate(self, date):
        self._date = date

    def setAsync(self, request_async):
        self._async = request_async

    def _hash_hmac(self):
        if self._checkAction == 0:
            s = self._username + ":" + self._password
            return "Basic " + base64.b64encode(s.encode()).decode()
        if not self._url:
            raise Exception('url invaild')
        if not self._method:
            raise Exception('method invaild')

        parse = urlparse(self._url)
        uri = parse.path
        if parse.query:
            uri = uri + "?" + parse.query
        if not uri:
            uri = "/"
        print(uri)
        code = self._method + "&" + uri + "&" + self._date
        if self._contentMd5:
            code = code + "&" + self._contentMd5
        print(code)
        hmac_code = hmac.new(base64.b64encode(self._password.encode('utf-8')), code.encode(), hashlib.sha1)
        return "WESTYUN " + self._username + ":" + base64.b64encode(hmac_code.digest()).decode()

    def _http_request(self, req):
        try:
            print(req.headers)
            resp = request.urlopen(req)
            if self._method == 'HEAD':
                return resp.info()
            else:
                return resp.read()
        except error.HTTPError as e:
            return e.fp.read()

    def getList(self):
        """
        获取列表
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        data = self._http_request(req)
        return data

    def getFileInfo(self):
        """
        获取文件元信息
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        data = self._http_request(req)
        return data

    def getContent(self, start=None, end=None):
        """
        获取文件内容
        :param start: 起始字节
        :param end: 截止字节
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        if start is not None and end is None :
            req.add_header("Range", "bytes="+str(start) + "-")
        if start is None and end is not None:
            req.add_header("Range", "bytes=-" + str(end))
        if start is not None and end is not None:
            req.add_header("Range", "bytes=" + str(start) + "-" + str(end))
        data = self._http_request(req)
        return data

    def copyOrMoveFile(self, source, type, directive=None, meta=None):
        """
        复制或者移动文件
        :param source:
        :param type:
        :param directive:
        :param meta:
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        if type == 0:
            req.add_header("x-west-copy-source", source)
        else:
            req.add_header("x-west-move-source", source)
        if directive:
            req.add_header("x-west-metadata-directive", directive)
        if meta:
            for k in meta:
                key = "x-west-meta-" + str(k)
                req.add_header(key, meta[k])
        data = self._http_request(req)
        return data

    def createFolder(self):
        """
        创建目录
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        req.add_header("folder", 'true')
        if self._date:
            req.add_header("Date", self._date)
        data = self._http_request(req)
        return data

    def deleteFolderOrFlie(self):
        """
        删除目录或文件
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        if self._async:
            req.add_header("x-west-async", "true")
        data = self._http_request(req)
        return data

    def setMetadata(self, metaInfo):
        """
        设置metadata
        :param metaInfo:
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        for k in metaInfo:
            key = "x-west-meta-" + str(k)
            req.add_header(key, metaInfo[k])
        data = self._http_request(req)
        return data

    def uploadFile(self, path, type=None, secret=None, ttl=None, thumb=None, metaInfo=None):
        """
        上传文件
        :param path:
        :param type:
        :param secret:
        :param ttl:
        :param thumb:
        :param metaInfo:
        :return:
        """
        fp = open(path, 'rb')
        content = fp.read()
        fp.close()
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        if self._contentMd5:
            req.add_header("Content-MD5", self._contentMd5)
        if self._async:
            req.add_header("x-west-async", "true")
        if type:
            req.add_header("Content-Type", type)
        if secret:
            req.add_header("Content-Secret", secret)
        if ttl:
            req.add_header("x-west-meta-ttl", str(ttl))
        if thumb:
            req.add_header("x-gmkerl-thumb", thumb)
        if metaInfo:
            for k in metaInfo:
                key = "x-west-meta-" + str(k)
                req.add_header(key, metaInfo[k])
        req.data = content
        data = self._http_request(req)
        return data

    def bigFileInit(self, length, type=None, secret=None, ttl=None, metaInfo=None):
        """
        初始化大文件
        :param length:
        :param type:
        :param secret:
        :param ttl:
        :param metaInfo:
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        req.add_header("x-west-multi-disorder", "true")
        req.add_header("x-west-multi-stage", "initiate")
        req.add_header("x-west-multi-length", length)
        if type:
            req.add_header("Content-Type", type)
        if secret:
            req.add_header("Content-Secret", secret)
        if ttl:
            req.add_header("x-west-meta-ttl", str(ttl))
        if metaInfo:
            for k in metaInfo:
                key = "x-west-meta-" + str(k)
                req.add_header(key, metaInfo[k])
        data = self._http_request(req)
        return data

    def chunkUpload(self, chuckId, content):
        """
        分块上传大文件
        :param chuckId:
        :param content:
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        req.add_header("x-west-multi-disorder", "true")
        req.add_header("x-west-multi-stage", "upload")
        req.add_header("x-west-part-id", chuckId)
        req.data = content
        data = self._http_request(req)
        return data

    def bigFileComplete(self):
        """
        完成大文件上传
        :return:
        """
        authorization = self._hash_hmac()
        req = request.Request(self._url, method=self._method)
        req.add_header("Authorization", authorization)
        if self._date:
            req.add_header("Date", self._date)
        req.add_header("x-west-multi-disorder", "true")
        req.add_header("x-west-multi-stage", "complete")
        data = self._http_request(req)
        return data


if __name__ == "__main__":
    pytz.timezone('Asia/Shanghai')
    username = "用户名"
    password = "密码"
    checkAction = 1  # 0为基础认证，其他为签名认证
    url = "http://fss-my.vhostgo.com"
    r = restapi(username, password, checkAction)
    r.setDate(datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'))
    # 获取列表
    # r.setMethod('GET')
    # r.setUrl(url+"/zswtest/")
    # data = r.getList()
    # print(data)
    # 获取文件元信息
    # r.setMethod('HEAD')
    # r.setUrl(url + "/westtest/wang.txt")
    # data = r.getFileInfo()
    # 获取文件内容
    # r.setMethod('GET')
    # r.setUrl(url + "/westtest/djtest/456.rar")
    # for i in range(10):
    #     chucksize = 1 * 1024 * 1024
    #     start = i * chucksize
    #     end = start + chucksize
    #     data = r.getContent(start, end)
    #     print(data)
    # 创建目录
    # r.setMethod('POST')
    # r.setUrl(url + "/westtest/test4")
    # data = r.createFolder()
    # print(data)
    # 复制文件
    # r.setMethod('PUT')
    # r.setUrl(url + "/westtest/test4/wang.txt")
    # data = r.copyOrMoveFile('/westtest/wang.txt', 0)
    # print(data)
    # 移动文件
    # r.setMethod('PUT')
    # r.setUrl(url + "/westtest/test4/wang.txt")
    # data = r.copyOrMoveFile('/westtest/wang.txt', 0)
    # print(data)
    # 删除文件或目录
    # r.setMethod('DELETE')
    # r.setUrl(url + "/westtest/test4/wang.txt")
    # r.setUrl(url + "/westtest/test4")
    # data = r.deleteFolderOrFlie()
    # print(data)
    # 设置metadata
    # metaInfo = {"a":1,"b":2,"c":3}
    # r.setMethod('PATCH')
    # r.setUrl(url + "/westtest/test2/wang.txt?metadate=merge")
    # data = r.setMetadata(metaInfo)
    # print(data)
    # 上传文件
    # metaInfo = {"a":1,"b":2,"c":3}
    # r.setMethod('PUT')
    # r.setUrl(url + "/westtest/index.html")
    # data = r.uploadFile("D:\\index.html", 'exe', 'test', 150, None, metaInfo)
    # print(data)
    # 分块上传文件
    # size = os.path.getsize("D:\\chromedriver.exe")
    # metaInfo = {"a": 5, "b": 6, "c": 4}
    # r.setMethod('PUT')
    # r.setUrl(url + "/westtest/test3/chromedriver.exe")
    # data = r.bigFileInit(size, 'exe', 'test123', 150, metaInfo)
    # print(data)
    # chunksize = 1024 * 1024
    # fp = open("D:\\chromedriver.exe", 'rb')
    # chunk = math.ceil(size / chunksize)
    # for i in range(chunk):
    #     content = fp.read(chunksize)
    #     data = r.chunkUpload(i, content)
    #     print(data)
    # data = r.bigFileComplete()
    # print(data)
